/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWMapNode;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.property.VWBaseStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWStepPropTabPanel;
import filenet.vw.toolkit.runtime.property.images.VWImageLoader;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VWCallStepGeneralPanel
extends VWStepPropTabPanel {
    private VWToolbarBorder m_mapBorder = null;
    private VWMapNode m_mapNode;
    private String m_mapName;
    private JTextField m_mapNameUI;
    private JTextField m_receivedUI = new JTextField();
    private Date m_receivedStep = null;
    private JTextField m_statusUI = new JTextField();
    private JLabel m_statusIcon = new JLabel();
    private int m_statusStep = 0;
    private Date m_statusStepDate = null;
    private DateFormat m_dateTimeFormatter = DateFormat.getDateTimeInstance(2, 2);

    public VWCallStepGeneralPanel(Frame parentFrame, VWBaseStepPropPanel propPanel) {
        super(parentFrame, propPanel);
        this.m_type = 1;
        this.preSetupLayout();
    }

    protected void initData() throws Exception {
        if (this.isInitialized()) {
            return;
        }
        try {
            this.m_mapName = null;
            if (this.m_step != null) {
                this.m_mapNode = this.m_step.getMapNode();
                this.m_mapName = VWStepUtils.getCalledMapName(this.m_mapNode);
                this.initCommonInfoPanelData();
            } else {
                this.m_mapNode = null;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
    }

    protected void preSetupLayout() {
        this.m_mapBorder = new VWToolbarBorder(VWResource.s_map, 0);
        JPanel mapPanel = this.m_mapBorder.getClientPanel();
        mapPanel.setLayout(new BorderLayout());
        mapPanel.add((Component)this.setupCommonInfoPanel(), "First");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_mapBorder, "First");
    }

    protected void setupLayout() {
        this.updateDisplay();
    }

    protected void updateDisplay() {
        this.updateCommonInfoPanel();
    }

    private JPanel setupCommonInfoPanel() {
        JPanel panel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(new GridBagLayout());
        this.m_mapNameUI = new JTextField();
        this.m_mapNameUI.setEditable(false);
        this.m_mapNameUI.setBorder(null);
        this.updateCommonInfoPanel();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 23;
        c.weightx = 1.0;
        panel.add((Component)this.m_mapNameUI, c);
        return panel;
    }

    void updateCommonInfoPanel() {
        this.m_mapNameUI.setText(this.m_mapName);
        if (this.m_step == null) {
            this.m_receivedUI.setText("");
            this.m_statusUI.setText("");
            this.m_statusIcon.setIcon(null);
        } else {
            if (this.m_receivedStep != null) {
                this.m_receivedUI.setText(this.m_dateTimeFormatter.format(this.m_receivedStep));
            } else {
                this.m_receivedUI.setText("");
            }
            Date date = this.m_statusStepDate;
            if (date != null) {
                this.m_statusUI.setText(this.m_dateTimeFormatter.format(date));
            } else {
                this.m_statusUI.setText("");
            }
            int status = this.m_statusStep;
            ImageIcon icon = VWImageLoader.createStatusIcon(status);
            this.m_statusIcon.setIcon(icon);
            switch (status) {
                case 1: {
                    this.m_statusUI.setText(VWResource.s_inProgress);
                    break;
                }
                case 9: {
                    this.m_statusUI.setText(VWResource.s_overdue);
                    break;
                }
                case 10: {
                    this.m_statusUI.setText(VWResource.s_reminded);
                    break;
                }
                case 12: {
                    this.m_statusUI.setText(VWResource.s_exception);
                    break;
                }
                case 13: {
                    this.m_statusUI.setText(VWResource.s_pastException);
                }
            }
        }
    }

    protected void initCommonInfoPanelData() {
        if (this.m_stepOccurrence != null) {
            this.m_receivedStep = this.m_stepOccurrence.getDateReceived();
            this.m_statusStep = this.m_stepOccurrence.getStatus();
            this.m_statusStepDate = this.m_stepOccurrence.getCompletionDate();
        } else {
            this.m_receivedStep = null;
            this.m_statusStep = 0;
            this.m_statusStepDate = null;
        }
    }

    public void removeReferences() {
        this.m_mapNode = null;
        this.m_mapName = null;
        this.m_mapNameUI = null;
        if (this.m_mapBorder != null) {
            this.m_mapBorder.removeReferences();
            this.m_mapBorder = null;
        }
        this.m_receivedUI = null;
        this.m_receivedStep = null;
        this.m_statusUI = null;
        this.m_statusIcon = null;
        this.m_statusStepDate = null;
        super.removeReferences();
    }
}

